//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Validation
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class ValidationForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label rangeLabel;
		private System.Windows.Forms.TextBox range;
		private System.Windows.Forms.Label alphaLabel;
		private System.Windows.Forms.TextBox alpha;
		private ErrorProvider errorProvider;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ValidationForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			errorProvider = new ErrorProvider();

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.range = new System.Windows.Forms.TextBox();
			this.rangeLabel = new System.Windows.Forms.Label();
			this.alphaLabel = new System.Windows.Forms.Label();
			this.alpha = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// range
			// 
			this.range.Location = new System.Drawing.Point(216, 16);
			this.range.Name = "range";
			this.range.TabIndex = 1;
			this.range.Text = "";
			this.range.Validating += new System.ComponentModel.CancelEventHandler(this.OnRangeValidating);
			// 
			// rangeLabel
			// 
			this.rangeLabel.Location = new System.Drawing.Point(8, 24);
			this.rangeLabel.Name = "rangeLabel";
			this.rangeLabel.Size = new System.Drawing.Size(152, 16);
			this.rangeLabel.TabIndex = 0;
			this.rangeLabel.Text = "Wprowad liczb od 1 do 10";
			// 
			// alphaLabel
			// 
			this.alphaLabel.Location = new System.Drawing.Point(8, 56);
			this.alphaLabel.Name = "alphaLabel";
			this.alphaLabel.Size = new System.Drawing.Size(192, 16);
			this.alphaLabel.TabIndex = 2;
			this.alphaLabel.Text = "Wprowad znaki alfanumeryczne";
			// 
			// alpha
			// 
			this.alpha.Location = new System.Drawing.Point(216, 48);
			this.alpha.Name = "alpha";
			this.alpha.TabIndex = 3;
			this.alpha.Text = "";
			this.alpha.Validating += new System.ComponentModel.CancelEventHandler(this.OnAlphaNumericValidating);
			// 
			// ValidationForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(336, 101);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.alpha,
																		  this.alphaLabel,
																		  this.range,
																		  this.rangeLabel});
			this.Name = "ValidationForm";
			this.Text = "Weryfikacja danych uytkownika";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ValidationForm());
		}

		private void OnRangeValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			TextBox t = sender as TextBox;
			try 
			{
				int x = Int32.Parse(t.Text);
				if(x > 0 && x <= 10)
					errorProvider.SetError(t, "");
				else
				{
                    errorProvider.SetError(t, string.Format("Niewaciwy zakres. {0} nie znajduje si pomidzy 1 a 10", x));
					throw new ArgumentOutOfRangeException(t.ToString(), x, "Wprowad liczb od 1 do 10");
				}
			}
			catch(FormatException) 
			{
				errorProvider.SetError(t, string.Format("\"{0}\" nie jest liczb cakowit.", t.Text));
				throw;
			}
			catch(OverflowException) 
			{
				errorProvider.SetError(t, string.Format("Uzyskana warto jest > {0} lub < {1}.", Int32.MaxValue, Int32.MinValue));
				throw;
			}
			catch(ArgumentNullException) 
			{
				errorProvider.SetError(t, "Pusty cig.");
				throw;
			}
		}

		private void OnAlphaNumericValidating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			string characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
			TextBox t = sender as TextBox;
			errorProvider.SetError(t, "");
			foreach(char c in t.Text)
			{
				if(characters.IndexOf(c) == -1)
				{
					errorProvider.SetError(t, "Prosz wprowadzi cig alfanumeryczny.");
					throw new ArgumentOutOfRangeException(t.ToString(), c, "Naley wprowadzi cig alfanumeryczny");
				}
			}
		}
	}
}
